// src/utils/tokenUtils.js
'use client';

import Cookies from 'js-cookie';

const COOKIE_OPTIONS = {
  expires: 1,
  path: '/',
  sameSite: 'Lax',
  secure: process.env.NODE_ENV === 'production',
};

export function setAuthToken(token) {
  Cookies.set('token', token, COOKIE_OPTIONS);
}

export function getAuthToken() {
  return Cookies.get('token');
}

export function removeAuthToken() {
  Cookies.remove('token', { path: '/' });
}
