// utils/format.js

export const formatNumber = (value, locale = 'en') => {
  const lang = locale === 'ar' ? 'en-US' : 'en-US';
  const number = Number(value);
  if (isNaN(number)) return value;
  return number.toLocaleString(lang, { 
    minimumFractionDigits: 0,
    maximumFractionDigits: 0,
  });
};
export const formatCurrency = (value, locale = 'en') => {
  const lang = locale === 'ar' ? 'en-US' : 'en-US';
  const number = Number(value);
  if (isNaN(number)) return value;
  return number.toLocaleString(lang, {
    minimumFractionDigits: 2,
    maximumFractionDigits: 2,
  });
};

export const formatPrice = (value) => {
  const number = Number(value);
  if (isNaN(number)) return '0.00';
  return number.toFixed(2);
};

export const formatOrderNumber = (id) => {
  if (!id) return '';
  return `#${String(id)}`;
};

export const formatDate = (dateStr, locale = 'en') => {
  if (!dateStr) return '';
  const date = new Date(dateStr);
  return date.toLocaleDateString(locale === 'ar' ? 'en-US' : 'en-US', {
    year: 'numeric',
    month: '2-digit',
    day: '2-digit',
  });
};
