/**
 * Authentication utility functions
 * دوال مساعدة للمصادقة
 */
'use client';

import Cookies from 'js-cookie';
import cookieStorage from './cookieStorage';
import { removeAuthToken } from './tokenUtils';

/**
 * Handle user logout
 * معالجة تسجيل خروج المستخدم
 * @returns {boolean} - true if logout was successful
 */
export const handleLogout = () => {
  try {
    // Remove all user data from cookieStorage
    cookieStorage.removeItem("token");
    cookieStorage.removeItem("user");
    cookieStorage.removeItem("rememberMobile");
    cookieStorage.removeItem("rememberPassword");
    cookieStorage.removeItem("id");

    // Remove cookies using token utils
    removeAuthToken();
    Cookies.remove("clientId", { path: '/' });

    return true;
  } catch (error) {
    console.error('Error during logout:', error);
    return false;
  }
};

/**
 * Check if user is authenticated
 * التحقق من مصادقة المستخدم
 * @returns {boolean} - true if user is logged in
 */
export const isAuthenticated = () => {
  const token = cookieStorage.getItem("token");
  return !!token;
};

/**
 * Get current user data
 * الحصول على بيانات المستخدم الحالي
 * @returns {Object|null} - user object or null
 */
export const getCurrentUser = () => {
  try {
    const userData = cookieStorage.getItem("user");
    return userData ? JSON.parse(userData) : null;
  } catch (error) {
    console.error('Error getting current user:', error);
    return null;
  }
};

