 

'use client';

import { getAuthToken } from '@/utils/tokenUtils';
import { useLocale } from 'next-intl';
import { useRouter } from 'next/navigation';
import { useEffect } from 'react';

export default function ProtectedRoute({ children }) {
    const router = useRouter();
    const token = getAuthToken();
    const locale = useLocale();

    useEffect(() => {
        if (!token) {
            router.push(`/${locale}/login`);
        }
    }, [token]);

    if (!token) return null;

    return children;
}
