import forgotPasswordReducer from '@/lib/auth/forgotPasswordSlice';
import { loginReducer } from '@/lib/auth/loginSlice';
import { profileReducer } from '@/lib/auth/profileSlice';
import { signupReducer } from '@/lib/auth/signupSlice';
import { cityReducer } from '@/lib/get/citySlice';
import rentalReducer from '@/store/features/rental/rentalSlice';
import { configureStore } from '@reduxjs/toolkit';
import limousineReducer from '@store/features/lim/limousineSlice.js';
import validationReducer from '@store/features/validation/booking/validationSlice.js';
import sharedReducer from "@store/shared/sharedSlice";
 
export const store = configureStore({
  reducer: {
    rental: rentalReducer,
    login: loginReducer,
    shared: sharedReducer,
    forgotPassword: forgotPasswordReducer,

    // Add other reducers here
    city: cityReducer,
    signup: signupReducer,
    profile: profileReducer,
    validation: validationReducer,
    limousine: limousineReducer,


  },
});
