// src/middleware.js
import createMiddleware from 'next-intl/middleware';

// إعداد تعدد اللغات
const intlMiddleware = createMiddleware({
  locales: ['ar', 'en'],
  defaultLocale: 'ar',
  localePrefix: 'always',
  localeDetection: false, // تعطيل الاكتشاف التلقائي للغة - دائماً استخدام العربية كافتراضية
}); 
export function middleware(request) {
  
  return intlMiddleware(request);
}

export const config = {
  matcher: ['/', '/(ar|en)/:path*'],
};