
import { createAsyncThunk, createSlice } from '@reduxjs/toolkit';
import { URL } from '../../constants/api';

export let getCity = createAsyncThunk('get/allCity', async (city) => {
    const url = URL('/city/findall');
    const response = await fetch(url);
    if (!response.ok) {
        throw new Error('Failed to fetch cities');
    }
    const { data } = await response.json(); 
    return data;
});

let initialState = {
    city: [],
    loading: false,
    error: null,
}
let citySlice = createSlice({
    name: 'getcity',
    initialState,
    extraReducers: (builder => {
        builder
        .addCase(getCity.fulfilled, (state, action) => {
            state.city = action.payload;
            state.loading = false
        })
        .addCase(getCity.pending, (state) => {
            state.loading = true
        })
        .addCase(getCity.rejected, (state, action) => {
            state.loading = false
            state.error = action.payload
        }) 
    })
})

export let cityReducer = citySlice.reducer