/**
 * Hook for managing session storage cleanup
 * Hook لإدارة تنظيف session storage
 */

import {
  clearAllBookingData,
  clearRentalBookingData
} from '@/utils/sessionUtils';
import { clearRentalData } from '@store/features/rental/rentalSlice';
import { useCallback } from 'react';
import { useDispatch } from 'react-redux';

// Import Redux actions for clearing store data

export const useSessionCleanup = () => {
  const dispatch = useDispatch();

  /**
   * حذف بيانات الحجز العادي مع تنظيف Redux storeّ
   * Clear rental booking data and Redux store
   */
  const clearRentalBookingDataWithStore = useCallback(() => {
    clearRentalBookingData();
    dispatch(clearRentalData());
    clearAllBookingData()
  }, [dispatch]);

  return {
    // Basic functions (without Redux store clearing)
    clearRentalBookingDataWithStore
  };
}; 