import { getPasswordChecks } from '@/utils/passwordValidation';
import { useEffect, useState } from 'react';

export const usePasswordValidation = () => {
  const [password, setPassword] = useState('');
  const [passwordChecks, setPasswordChecks] = useState({
    length: false,
    uppercase: false,
    lowercase: false,
    number: false,
    special: false
  });

  useEffect(() => {
    const checks = getPasswordChecks(password);
    setPasswordChecks(checks);
  }, [password]);

  const getCheckIcon = (isValid) => (
    <span className={`text-sm ${isValid ? 'text-green-500' : 'text-gray-400'}`}>
      {isValid ? '✓' : '○'}
    </span>
  );

  return {
    password,
    setPassword,
    passwordChecks,
    getCheckIcon
  };
};
