import { useEffect, useState } from 'react';

const useIsMobile = (breakpoint = 768) => {
  const [isMobile, setIsMobile] = useState(false);
  const [isTablet, setIsTablet] = useState(false);
  const [isMounted, setIsMounted] = useState(false);

  useEffect(() => {
    setIsMounted(true);
    
    const checkDeviceSize = () => {
      const width = window.innerWidth;
      setIsMobile(width < breakpoint);
      setIsTablet(width >= breakpoint && width <= 1024);
    };

    // Check on mount
    checkDeviceSize();

    // Listen for resize events
    window.addEventListener('resize', checkDeviceSize);
    
    return () => window.removeEventListener('resize', checkDeviceSize);
  }, [breakpoint]);

  // Return false on server side or until mounted
  return isMounted ? { isMobile, isTablet } : { isMobile: false, isTablet: false };
};

export default useIsMobile;
