import { apiPost } from '@/lib/apiPost';
import { useRouter } from '@/navigation';
import { setReservationLimPriceResult } from '@/store/features/lim/limousineSlice'; // عدّل المسار حسب مكان slice
import cookieStorage from '@/utils/cookieStorage';
import { message } from 'antd';
import { useTranslations } from 'next-intl';
import { useState } from 'react';
import { useDispatch } from 'react-redux';
export const useCalculateReservationLimPrice = ( form ) => {
  const router = useRouter();
  // Check if token exists
  const token = typeof window !== 'undefined' ? cookieStorage.getItem('token') : null;
  let t = useTranslations('validation');
  const [loading, setLoading] = useState(false);
  const [priceResult, setPriceResult] = useState(null);
  const [error, setError] = useState(null);
  const dispatch = useDispatch(); // ✅ لربط الريدوكس
  const calculatePrice = async (params) => {
    if (!token) {
     return router.push('/login');
    }
    setLoading(true);
    setError(null);
    setPriceResult(null);

    try {
      const locationMap = {
        JEDDAH_AIRPORT: 1,
        JEDDAH: 2,
        MAKKAH: 3,
      };

      // Map location codes to IDs as per API specification
      const mappedParams = {
        ...params,
        from: locationMap[params.from] || params.from,
        to: locationMap[params.to] || params.to,
      };

      // Prepare parameters according to API specification
      const apiParams = {
        reservationType: mappedParams.reservationType || "AIRPORT",
        reservationDate: mappedParams.reservationDate,
        carId: mappedParams.carId,
        from: mappedParams.from,
        to: mappedParams.to,
        promoCode: mappedParams.promoCode || null,
        flightNumber: mappedParams.flightNumber || null,
        additionalHoursPerDay: mappedParams.additionalHoursPerDay || null,
        // بيانات إضافية لـ other places
        ...(mappedParams.address && { address: mappedParams.address }),
        ...(mappedParams.latitude && { latitude: mappedParams.latitude }),
        ...(mappedParams.longitude && { longitude: mappedParams.longitude }),
        ...(mappedParams.toAddress && { toAddress: mappedParams.toAddress }),
        ...(mappedParams.toLatitude && { toLatitude: mappedParams.toLatitude }),
        ...(mappedParams.toLongitude && { toLongitude: mappedParams.toLongitude }),
        // Optional parameters
        ...(mappedParams.hours && { hours: mappedParams.hours }),
        ...(mappedParams.days && { days: mappedParams.days }),
        ...(mappedParams.additionalHoursPerDay && { additionalHoursPerDay: mappedParams.additionalHoursPerDay }),
        ...(mappedParams.pointsToUse && { pointsToUse: mappedParams.pointsToUse }),
        ...(mappedParams.notes && { notes: mappedParams.notes }),
        ...(mappedParams.servicesAddons && { servicesAddons: mappedParams.servicesAddons }),
        ...(mappedParams.carExtraKmQuotas && { carExtraKmQuotas: mappedParams.carExtraKmQuotas }),
      };

      // Remove undefined and null values
      const filteredParams = Object.fromEntries(
        Object.entries(apiParams).filter(
          ([_, value]) =>
            value !== undefined &&
            value !== null &&
            value !== ''
        )
      );


      // استخدام نفس API لجميع أنواع الحجز
      const apiEndpoint = '/limousine-reservations/price-preview';

      const data = await apiPost(apiEndpoint, {
        method: 'POST',
        body: JSON.stringify(filteredParams)
      });
      // Check if the response contains an error
      if (data && data.message) {
        message.error(t(data.message));
        throw new Error(data.message);
      }

      // Get car data from cookie storage and add it to the result
      const carLimData = typeof window !== 'undefined' ? cookieStorage.getItem('carLimData') : null;
      const carData = carLimData ? JSON.parse(carLimData) : null;

      // Add car information to the result
      const resultWithCarData = {
        ...data,
        carData: carData
      };

      // ✅ حفظ في cookie storage
      if (typeof window !== 'undefined') {
        cookieStorage.setItem('reservationPriceLimResult', JSON.stringify(resultWithCarData));
      }

      // ✅ حفظ في Redux
      dispatch(setReservationLimPriceResult(resultWithCarData));

      setPriceResult(resultWithCarData); 
      return resultWithCarData;
    } catch (err) {
      setError(err);
      // Show error message to user
        if (err.message) {
          message.error(t(err.message));
          if (err.message === 'PROMO_NOT_EXISTS') { 
            form.setFieldValue('promoCode', null);
          }
        } else {
        message.error('حدث خطأ أثناء حساب السعر. يرجى المحاولة مرة أخرى.');
      }
    } finally {
      setLoading(false);
    }
  };

  return { calculatePrice, loading, priceResult, error };
};
