import { createRoot } from 'react-dom/client';
import NotificationComponent from './NotificationComponent';
let notificationContainer = null;
let notificationRoot = null;

export const showCustomNotification = ({
  title = 'حجزك جاهزاً! تفاصيل الحجز موجودة في حسابك',
  description = '',
  icon = '🚗',
  duration = 6000
}) => {
  // إزالة الإشعار السابق إن وجد
  hideCustomNotification();

  // إنشاء container للإشعار
  notificationContainer = document.createElement('div');
  document.body.appendChild(notificationContainer);

  // إنشاء root للـ React 18
  notificationRoot = createRoot(notificationContainer);

  // دالة لإغلاق الإشعار
  const closeNotification = () => {
    hideCustomNotification();
  };

  // عرض الإشعار
  notificationRoot.render(
    <NotificationComponent
      title={title}
      description={description}
      icon={icon}
      onClose={closeNotification}
    />
  );

  // إغلاق تلقائي بعد المدة المحددة
  if (duration > 0) {
    setTimeout(() => {
      hideCustomNotification();
    }, duration);
  }
};

export const hideCustomNotification = () => {
  if (notificationRoot && notificationContainer) {
    // إضافة animation للإخفاء
    notificationContainer.style.animation = 'slideUp 0.3s ease-in forwards';
    
    setTimeout(() => {
      notificationRoot.unmount();
      if (notificationContainer && notificationContainer.parentNode) {
        notificationContainer.parentNode.removeChild(notificationContainer);
      }
      notificationContainer = null;
      notificationRoot = null;
    }, 300);
  }
};

// إضافة CSS للـ animations
const addNotificationStyles = () => {
  if (!document.getElementById('custom-notification-styles')) {
    const style = document.createElement('style');
    style.id = 'custom-notification-styles';
    style.textContent = `
      @keyframes slideDown {
        from {
          opacity: 0;
          transform: translateX(-50%) translateY(-20px);
        }
        to {
          opacity: 1;
          transform: translateX(-50%) translateY(0);
        }
      }
      
      @keyframes slideUp {
        from {
          opacity: 1;
          transform: translateX(-50%) translateY(0);
        }
        to {
          opacity: 0;
          transform: translateX(-50%) translateY(-20px);
        }
      }
    `;
    document.head.appendChild(style);
  }
};

// إضافة الـ styles عند تحميل الملف
if (typeof window !== 'undefined') {
  addNotificationStyles();
}
