// API Configuration
export const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || 'https://viganium.me/api';
export const AUTH_BASE_URL = process.env.NEXT_PUBLIC_AUTH_BASE_URL || 'https://viganium.me/auth';

// Helper function to build full API URLs
export const URL = (endpoint) => {
  const baseUrl = API_BASE_URL;
  if (!baseUrl) {
    // API_BASE_URL is not defined
    return '';
  }
  return `${baseUrl}${endpoint}`;
};

// Helper function to build full Auth URLs
export const AUTH_URL = (endpoint) => {
  const baseUrl = AUTH_BASE_URL;
  if (!baseUrl) {
    // AUTH_BASE_URL is not defined
    return '';
  }
  return `${baseUrl}${endpoint}`;
};
