export default function robots() {
  const baseUrl = 'https://www.alghazal.sa';

  return {
    rules: [
      {
        userAgent: '*',
        allow: '/',
        disallow: [
          // ملفات Next.js الداخلية 
          
          // APIs والمسارات المحمية
          '/api/',
          '/admin/',
          '/private/',
          
          // صفحات المستخدم المحمية
          '/ar/profile',
          '/en/profile',
          '/ar/orders',
          '/en/orders',
          '/ar/booking',
          '/en/booking',
          '/ar/booking/checkout',
          '/en/booking/checkout',
          '/ar/limo-checkout',
          '/en/limo-checkout',
          '/ar/checkout',
          '/en/checkout',
          '/ar/order',
          '/en/order',
          '/ar/payment-result',
          '/en/payment-result',
          '/ar/activation',
          '/en/activation',
          '/ar/verify-account-recovery',
          '/en/verify-account-recovery',
          '/ar/thanks-page',
          '/en/thanks-page',
          
          // صفحات Auth (noindex)
          '/ar/login',
          '/en/login',
          '/ar/sign-up',
          '/en/sign-up',
          '/ar/login/forgot-password',
          '/en/login/forgot-password',
          '/ar/reset-password',
          '/en/reset-password',
        ],
      },
      {
        userAgent: 'Googlebot',
        allow: '/',
        disallow: [
          '/api/',
          '/admin/',
          '/private/',
        ],
      },
    ],
    sitemap: [
      `${baseUrl}/sitemap.xml`,
      `${baseUrl}/blogs/sitemap.xml`,
    ],
  };
}