import { Analytics } from '@vercel/analytics/next';
import { SpeedInsights } from '@vercel/speed-insights/next';
import { getLocale } from 'next-intl/server';
import { Cairo } from 'next/font/google';
import FirebaseAnalytics from './(components)/FirebaseAnalytics';

const fontAr = Cairo({
    subsets: ['arabic', 'latin', 'latin-ext'],
    weight: ['400', '200', '300'],
    display: 'swap',
    variable: '--font-cairo',
});

export default async function RootLayout({ children }) {
    const locale = await getLocale();

    return (
        <html lang={locale} dir={locale === 'en' ? 'ltr' : 'rtl'} className={fontAr.variable}>
            <head>
                {/* DNS Prefetch for external resources */}
                <link rel="dns-prefetch" href="https://fonts.googleapis.com" />
                <link rel="dns-prefetch" href="https://fonts.gstatic.com" />
                <link rel="dns-prefetch" href="https://www.googletagmanager.com" />

                {/* Preconnect to Google Fonts for faster font loading */}
                <link rel="preconnect" href="https://fonts.googleapis.com" />
                <link rel="preconnect" href="https://fonts.gstatic.com" crossOrigin="anonymous" />
                {/* Preconnect to Google Tag Manager for faster loading */}
                <link rel="preconnect" href="https://www.googletagmanager.com" />

                {/* Google Tag Manager - Loaded asynchronously to avoid render blocking */}
                <script
                    async
                    dangerouslySetInnerHTML={{
                        __html:
                            "(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start': new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0], j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src='https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);})(window,document,'script','dataLayer','GTM-5TN5MHMN');",
                    }}
                />
                {/* End Google Tag Manager */}
            </head>
            <body style={{ fontFamily: fontAr.style.fontFamily }}>
                {/* Google Tag Manager (noscript) */}
                <noscript>
                    <iframe
                        src="https://www.googletagmanager.com/ns.html?id=GTM-5TN5MHMN"
                        height="0"
                        width="0"
                        style={{ display: 'none', visibility: 'hidden' }}
                    />
                </noscript>
                {children}
                <FirebaseAnalytics />
                <SpeedInsights />
                <Analytics />
            </body>
        </html>
    );
}


