'use client';


export default function GlobalError({ error, reset }) {
 

  return (
    <html>
      <body>
        <div className="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 flex items-center justify-center px-4">
          <div className="max-w-md w-full">
            <div className="bg-white rounded-2xl shadow-xl p-8 text-center relative">
              {/* Server Error Icon */}
              <div className="mx-auto w-20 h-20 bg-red-100 rounded-full flex items-center justify-center mb-6">
                <svg className="w-10 h-10 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z" />
                </svg>
              </div>

              {/* Error Title */}
              <h1 className="text-2xl font-bold text-gray-900 mb-2">
                عذراً، حدث خطأ في الخادم
              </h1>
              <h1 className="text-xl text-gray-700 mb-4">
                Sorry, Server Error Occurred
              </h1>

              {/* Error Description */}
              <p className="text-gray-500 mb-2 leading-relaxed">
                نحن نعمل على حل هذه المشكلة. يرجى المحاولة مرة أخرى بعد قليل.
              </p>
              <p className="text-gray-500 mb-8 leading-relaxed">
                We are working to resolve this issue. Please try again in a few moments.
              </p>

              {/* Action Buttons */}
              <div className="space-y-3">
                <button
                  onClick={reset}
                  className="w-full bg-red-600 hover:bg-red-700 text-white font-semibold py-3 px-6 rounded-lg transition-colors duration-200 shadow-lg hover:shadow-xl"
                >
                  حاول مرة أخرى / Try Again
                </button>
                
                <a
                  href="/"
                  className="w-full inline-block bg-gray-100 hover:bg-gray-200 text-gray-700 font-semibold py-3 px-6 rounded-lg transition-colors duration-200"
                >
                  العودة للرئيسية / Go to Home
                </a>
              </div>

              {/* Support Information */}
              <div className="mt-8 pt-6 border-t border-gray-200">
                <p className="text-sm text-gray-400 mb-2">
                  إذا استمرت المشكلة، يرجى التواصل مع فريق الدعم
                </p>
                <p className="text-sm text-gray-400 mb-2">
                  If the problem persists, please contact our support team
                </p>
                
                {error?.message && (
                  <div className="text-xs text-gray-300">
                    <span className="font-medium">رمز الخطأ / Error Code:</span> 
                    <span className="ml-1 font-mono">SERVER_DOWN</span>
                  </div>
                )}
              </div>

              {/* Decorative Elements */}
              <div className="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-red-500 to-red-600 rounded-t-2xl"></div>
            </div>

            {/* Additional Info Card */}
            <div className="mt-6 bg-white/50 backdrop-blur-sm rounded-xl p-4 text-center">
              <div className="flex items-center justify-center space-x-2">
                <div className="w-2 h-2 bg-red-400 rounded-full animate-pulse"></div>
                <span className="text-sm text-gray-600">
                  حالة الخادم: جارٍ الفحص... / Server Status: Checking...
                </span>
              </div>
            </div>
          </div>

          {/* Background Pattern */}
          <div className="absolute inset-0 -z-10 opacity-10">
            <div className="absolute inset-0" style={{
              backgroundImage: `url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fillRule='evenodd'%3E%3Cg fill='%23e5e7eb' fill-opacity='0.4'%3E%3Ccircle cx='30' cy='30' r='4'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E")`,
            }}></div>
          </div>
        </div>
      </body>
    </html>
  );
}
