import { Form, TimePicker } from 'antd';
import arEG from 'antd/es/date-picker/locale/ar_EG';
import enUS from 'antd/es/date-picker/locale/en_US';
import dayjs from 'dayjs';

const CustomTimePicker = ({
  name,
  label,
  placeholder = 'اختر الوقت',
  size = 'large',
  localeCode = 'ar',
  format = 'HH:mm',
  defaultValue = null,
  required = true, 
  ...props
}) => {
  const locale = localeCode === 'en' ? enUS : arEG;

  return (
    <Form.Item
      name={name}
      label={label}
      rules={[{ required: required, message: `يرجى اختيار ${label}` }]}
    >
      <TimePicker
        placeholder={placeholder}
        size={size}
        locale={locale}
        minuteStep={30}
        format={format}
        defaultValue={defaultValue ? dayjs(defaultValue) : null}
        style={{ width: '100%' }}
        className={props.className}
        {...props}
      />
    </Form.Item>
  );
};

export default CustomTimePicker;
