'use client';

import { Pagination } from 'antd';
import { useTranslations } from 'next-intl';
import './CustomPagination.css';

const CustomPagination = ({
  current = 1,
  total = 0,
  pageSize = 6,
  onChange,
  showSizeChanger = false,
  showQuickJumper = false,
  responsive = true,
  className = '',
  showTotal = true,
  itemType = 'cars', // cars, items, results, etc.
  ...props
}) => {
  const t = useTranslations();

  // دالة عرض إجمالي النتائج
  const renderShowTotal = (total, range) => {
    if (!showTotal) return null;
    
    // تحديد كلمة العنصر بناءً على النوع
    const carsWord = total === 1 ? t(`pagination.${itemType}`) : t(`pagination.${itemType}_plural`);
    return `${range[0]}-${range[1]} ${t('pagination.of')} ${total} ${carsWord}`;
  };

  return (
    <div className="w-full flex justify-center mt-8 mb-4">
      <Pagination
        current={current}
        total={total}
        pageSize={pageSize}
        onChange={onChange}
        showSizeChanger={showSizeChanger}
        showQuickJumper={showQuickJumper}
        showTotal={showTotal ? renderShowTotal : false}
        className={`custom-pagination ${className}`}
        responsive={responsive}
        {...props}
      />
    </div>
  );
};

export default CustomPagination;
