'use client';

import PromoCodeInputLimousine from '@/app/(components)/limousine/PromoCodeInputLimousine';
import Riyal from '@components/svg/Riyal';
// Break circular dependency with the UI barrel
import CustomSubmitReservation from '@ui/actions/CustomSubmitReservation';
import { Col, Row, Skeleton } from 'antd';
import { useLocale, useTranslations } from 'next-intl';

const ReservationActions = ({ 
    form, 
    loading, 
    priceResult, 
    onFinish, 
    back = "/cars",
    next = "complete_reservation"
}) => {
    const t = useTranslations();
    const locale = useLocale();

    return (
        <>
            <Row gutter={16} className="w-full mt-6">
                <Col span={24} dir="ltr" className='[&_.ant-form-item]:!mb-0' >
                    <PromoCodeInputLimousine
                        isLang={locale}
                        name="promoCode"
                        form={form}
                        validateReservation={onFinish}
                        dir={locale === 'ar' ? 'rtl' : 'ltr'}
                    />
                    <div className="summery_submit mt-7">
                        {loading ? (
                            <Skeleton active paragraph={{ rows: 1 }} />
                        ) : (
                            <div dir={locale == "en" ? 'ltr' : 'rtl'} className="flex justify-between items-center mb-8">
                                <strong className="text-[18px]">{t("total_amount")}</strong>
                                <h1 className="font-bold flex flex-row gap-2 items-center">
                                    {priceResult?.finalPrice > 0 ? priceResult.finalPrice : 0} <Riyal color="#162A2B" />
                                </h1>
                            </div>
                        )}
                    </div>
                </Col>
            </Row>
            <CustomSubmitReservation
                t={t}
                loading={loading}
                next={next}
                back={back}
                onSubmit={() => form.submit()}
            />
        </>
    );
};

export default ReservationActions; 