'use client';

import { CustomDropdown, CustomInput } from '@components/ui';
import { Col, Row } from 'antd';
import { useTranslations } from 'next-intl';
import MapLocationSelector from '../MapLocationSelector';

const LocationFields = ({ title, showTitle = true, form }) => {
    const t = useTranslations(); 
    const baseOptions = [
        { value: 'JEDDAH', label: t('limousine.jeddah') },
        { value: 'MAKKAH', label: t('limousine.makkah') },
    ];

    return (
        <>
            {showTitle && <strong className='bold mt-3 w-full text-[20px] font-semibold text-main mb-3'>  {title} </strong>}
            <Row gutter={[16, 0]}>
                <Col xs={24}>
                    <CustomDropdown
                        name="cityId"
                        options={baseOptions?.map(cityItem => ({
                            value: cityItem.value,
                            label: cityItem.label
                        })) || []}
                        placeholder={t('location.choose_city')}
                        className="w-full h-[50px] border !border-[#979797] rounded text-sm"
                    />
                </Col>
                <Col xs={24}>
                    <CustomInput
                        name="address"
                        placeholder={t('location.enter_address')}
                        className="w-full h-[50px] border !border-[#979797] rounded text-sm"
                        size="large"
                    />
                </Col>
                <Col xs={24}>
                    <MapLocationSelector
                        form={form}
                        addressName="address"
                        latName="latitude"
                        lngName="longitude"
                        label={t('pickup.pickup_location_label')}
                        placeholder={t('pickup.enter_address')}
                        address={false}
                        watchField="to"
                        className="h-[320px] mb-6"
                    />
                </Col>

                {/* {receptionData.typeLim === 'hourly' && (
                    <Col xs={24}>
                        <CustomInput
                            name="hours"
                            suffix={<span className='text-textLight'>{t('location.hours_suffix')}</span>}
                            placeholder={t('location.hours_count')}
                            className="w-full h-[50px] !border !border-[#979797] shadow-none rounded text-sm"
                        />
                    </Col>
                )} */}

                {/* {receptionData.typeLim === 'daily' && (
                    <Col xs={24}>
                        <CustomInput
                            name="days"
                            suffix={<span className='text-textLight'>{t('location.days_suffix')}</span>}
                            placeholder={t('location.days_count')}
                            className="w-full !h-[50px] !border !border-[#979797] !shadow-none rounded text-sm"
                        />
                    </Col>
                )} */}
            </Row>
        </>
    );
};

export default LocationFields; 