"use client";

import { formatCurrency } from '@/utils/format';
import Riyal from '@components/svg/Riyal';
import { Skeleton } from 'antd';

const SummaryRow = ({
  label = 'إجمالي المبلغ',
  labeltax   = 'شامل الضريبة',
  right,
  loading = false,
  dir = 'ltr', 
  className = ''
}) => { 

  return (
    <div className={`summery_submit ${className}`}>
      {loading ? (
        <Skeleton active paragraph={{ rows: 1 }} />
      ) : (
        <>
          <div className="flex justify-between max-md:flex-col max-md:gap-2 max-md:items-start max-md:justify-center items-center mt-4" >
            <div className="flex gap-2 max-md:gap-1 items-end"  >
              {/* السطر الأول */}
              <span className="text-main font-bold text-[20px] max-md:text-[16px] max-md:text-center">
                {label}
              </span>

              {/* السطر الثاني */}
              <span className="font-[Cairo] font-normal text-[14px] max-md:text-[12px] leading-[100%] text-[#7C7C7C] max-md:text-center">
                {labeltax}
              </span>
            </div>
            <div className="flex items-center gap-2 max-md:gap-1 [&_svg]:w-[18px] [&_svg]:h-[18px] max-md:text-center">
              <span className="font-[Cairo] font-bold text-[24px] max-md:text-[18px] text-secondary">
                {formatCurrency(right)}
              </span>
              <Riyal color="#CE931A" />
            </div>
          </div>
        </>
      )}
    </div>
  );
};

export default SummaryRow;
