"use client";

import Gift from "@components/svg/Gift";
import { Skeleton } from "antd";

const SummaryPromo = ({
  label,
  right,
  loading = false, 
  className = "",
}) => { 

  return (
    <div className={`summary_promo ${className}`}>
      {loading ? (
        <Skeleton active paragraph={{ rows: 1 }} />
      ) : (
        <>
          <div className="carOfferDiscount flex justify-between bg-[#EAF7F1] px-4 py-3 rounded-[5px]">
            <div className='flex gap-2'>
              <Gift />
              <label className='text-secondary'>{label}</label>
            </div>
            <div className="price flex gap-2 flex-row text-secondary">
              {right}
            </div>
          </div>
        </>
      )}
    </div>
  );
};

export default SummaryPromo;
