"use client";

import { useState } from 'react';
import DurationSelector from './DurationSelector';

const DurationSelectorExample = () => {
  const [selectedDuration, setSelectedDuration] = useState(5);

  const handleDurationChange = (value) => {
    setSelectedDuration(value);
   };

  return (
    <div className="p-6 space-y-6"> 

      {/* Custom Options */}
      <div> 
        <DurationSelector 
          options={[2, 3, 4, 5, 6, 8, 10, 12, 24]}
          value={selectedDuration}
          onChange={handleDurationChange}
          title="اختر المدة:"
        />
      </div>

      {/* Without Icon */}
      <div>
        <h3 className="text-lg font-semibold mb-2">Without Icon</h3>
        <DurationSelector 
          showIcon={false}
          value={selectedDuration}
          onChange={handleDurationChange}
          title="المدة المطلوبة:"
        />
      </div>

      {/* Disabled State */}
      <div>
        <h3 className="text-lg font-semibold mb-2">Disabled State</h3>
        <DurationSelector 
          disabled={true}
          value={5}
          title="المدة (معطل):"
        />
      </div>

      {/* Custom Styling */}
      <div>
        <h3 className="text-lg font-semibold mb-2">Custom Styling</h3>
        <DurationSelector 
          value={selectedDuration}
          onChange={handleDurationChange}
          className="border-blue-200 shadow-lg"
          title="المدة المخصصة:"
        />
      </div>

      {/* Different Sizes */}
      <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <h3 className="text-lg font-semibold mb-2">Small Options</h3>
          <DurationSelector 
            options={[1, 2, 3, 4, 5]}
            value={selectedDuration}
            onChange={handleDurationChange}
            title="ساعات قليلة:"
          />
        </div>
        
        <div>
          <h3 className="text-lg font-semibold mb-2">Extended Options</h3>
          <DurationSelector 
            options={[6, 8, 10, 12, 16, 20, 24, 30, 36, 48]}
            value={selectedDuration}
            onChange={handleDurationChange}
            title="ساعات طويلة:"
          />
        </div>
      </div>
    </div>
  );
};

export default DurationSelectorExample;
