"use client";

import { Button, Modal, Radio } from 'antd';
import { useTranslations } from 'next-intl';
import { useState } from 'react';
import './AdditionalHoursModal.css';
const AdditionalHoursModal = ({
    visible,
    onCancel,
    onConfirm,
    selectedHours = 0,
    maxHours = 8,
    form
}) => {
    const t = useTranslations();
    const [tempSelectedHours, setTempSelectedHours] = useState(selectedHours);

    const handleConfirm = () => {
        onConfirm(tempSelectedHours);

        onCancel();
    };

    const handleCancel = () => {
        setTempSelectedHours(selectedHours);
        onCancel();
    };

    const handleReset = () => {
        setTempSelectedHours(0);
        form.setFieldsValue({ additionalHoursPerDay: 0 });
        onConfirm(0); // استدعاء onConfirm لحفظ القيمة 0 في الكوكيز
        onCancel();
    };

    // إنشاء خيارات الساعات الإضافية
    const additionalHoursOptions = Array.from({ length: maxHours }, (_, i) => i + 1);

    return (
        <Modal
            title={null}
            open={visible}
            onCancel={handleCancel}
            footer={null}
            width={500}
            centered
            className="additional-hours-modal"
        >
            <div className="py-0">
                {/* Header مع زر الإغلاق */}
                <div className="flex justify-between items-center mb-6">
                    <h1 className="text-xl font-bold text-gray-800 text-center flex-1 mt-2">
                        {t('add_additional_hours')}
                    </h1>
                </div>

                {/* النص التوضيحي */}
                <div className="mb-6 text-center">
                    <p className="text-gray-600 text-sm leading-relaxed">
                        {t('daily_reservation_includes_10_hours')}
                    </p>
                    <p className="text-gray-800 font-semibold mt-3 text-right">
                        {t('select_additional_hours')}
                    </p>
                </div>

                {/* خيارات الساعات */}
                <div className="max-h-64 overflow-y-auto custom-scrollbar mb-6">
                    <Radio.Group
                        value={tempSelectedHours}
                        onChange={(e) => {
                            setTempSelectedHours(e.target.value);
                            form.setFieldsValue({ additionalHoursPerDay: e.target.value });
                        }}
                        className="w-full"
                    >
                        <div className="grid !grid-cols-4  gap- 4">
                            {additionalHoursOptions.map((hours) => (
                                <div
                                    key={hours}
                                    className={`flex mt-3 items-center justify-center p-4 border rounded-[4px] cursor-pointer transition-all duration-200 ${tempSelectedHours === hours
                                        ? '!bg-[#FBF7ED]  border-secondary  '
                                        : 'bg-white border-gray-200 text-gray-700 hover:bg-gray-50 hover:border-gray-300'
                                        }`}
                                    onClick={() => {
                                        setTempSelectedHours(hours);
                                        form.setFieldsValue({ additionalHoursPerDay: hours });
                                    }}
                                >
                                    <span className={`font-medium text-sm ${tempSelectedHours !== hours ? '!text-main font-bold' : 'text-gray-700'}`}>
                                        {hours === 1 ? t('hour') : hours === 2 ? t('two_hours') : `${hours} ${t('hours')}`}
                                    </span>
                                </div>
                            ))}
                        </div>
                    </Radio.Group>
                </div>

                {/* أزرار الإجراءات */}
                <div className="flex justify-end gap-3 pt-4 border-t border-gray-200">

                    <div className="flex gap-3">
                        <Button
                            onClick={handleReset}
                            danger
                            className="px-6 h-10  "
                        >
                            {t('cancel_additional_hours')}
                        </Button>
                        <Button
                            type="primary"
                            onClick={handleConfirm}
                            className="px-6 h-10  "
                        >
                            {t('confirm')}
                        </Button>
                    </div>
                </div>
            </div>
        </Modal>
    );
};

export default AdditionalHoursModal;
