"use client";

import { useTranslations } from 'next-intl';
import { useState } from 'react';
import TimeSlotSelector from './TimeSlotSelector';

const TimeSlotSelectorExample = () => {
  const [selectedTime, setSelectedTime] = useState(null);

  const handleTimeSelect = (timeSlot) => {
    setSelectedTime(timeSlot); 
  };
  let {t} = useTranslations();

  return (
    <div className="p-6 space-y-6">
      <h2 className="text-2xl font-bold mb-4">TimeSlotSelector Examples</h2>
      
      {/* Basic Usage */}
      <div>
        <h3 className="text-lg font-semibold mb-2">Basic Usage with Custom Scrollbar</h3>
        <TimeSlotSelector 
          onTimeSelect={handleTimeSelect}
          selectedTime={selectedTime}
          title={t('select_time')}  
        />
        {selectedTime && (
          <p className="mt-2 text-gray-600">
            Selected: {selectedTime.label} ({selectedTime.value})
          </p>
        )}
      </div>

      {/* Custom Hours */}
      <div>
        <h3 className="text-lg font-semibold mb-2">Custom Working Hours</h3>
        <TimeSlotSelector 
          onTimeSelect={handleTimeSelect}
          selectedTime={selectedTime}
          startHour={8}
          endHour={20}
          title={t('custom_working_hours')}
        />
      </div>

      {/* Different Interval */}
      <div>
        <h3 className="text-lg font-semibold mb-2">15 Minutes Interval</h3>
        <TimeSlotSelector 
          onTimeSelect={handleTimeSelect}
          selectedTime={selectedTime}
          interval={15}
          title={t('15_minutes_interval')}
        />
      </div>

      {/* With Working Hours */}
      <div>
        <h3 className="text-lg font-semibold mb-2">With Working Hours</h3>
        <TimeSlotSelector 
          onTimeSelect={handleTimeSelect}
          selectedTime={selectedTime}
          workingHours={{
            mon: 1,
            monOpenHour: 9,
            monOpenMin: 0,
            monCloseHour: 17,
            monCloseMin: 0,
            tues: 1,
            tuesOpenHour: 9,
            tuesOpenMin: 0,
            tuesCloseHour: 17,
            tuesCloseMin: 0,
            wed: 1,
            wedOpenHour: 9,
            wedOpenMin: 0,
            wedCloseHour: 17,
            wedCloseMin: 0,
            thurs: 1,
            thursOpenHour: 9,
            thursOpenMin: 0,
            thursCloseHour: 17,
            thursCloseMin: 0,
            fri: 1,
            friOpenHour: 9,
            friOpenMin: 0,
            friCloseHour: 17,
            friCloseMin: 0,
            sat: 0,
            sun: 0
          }}
          selectedDate={new Date()}
          title="مع مواعيد العمل"
        />
      </div>

      {/* Custom Styling */}
      <div>
        <h3 className="text-lg font-semibold mb-2">Custom Styling with Row & Col</h3>
        <TimeSlotSelector 
          onTimeSelect={handleTimeSelect}
          selectedTime={selectedTime}
          className="border-2 border-blue-200"
          className1="h-96"
          title="تصميم مخصص مع Row & Col"
        />
      </div>

      {/* Responsive Example */}
      <div>
        <h3 className="text-lg font-semibold mb-2">Responsive Design</h3>
        <p className="text-sm text-gray-600 mb-2">
          جرب تغيير حجم الشاشة لرؤية التصميم المتجاوب (4 أعمدة في الكبيرة، 3 في المتوسطة، 2 في الصغيرة)
        </p>
        <TimeSlotSelector 
          onTimeSelect={handleTimeSelect}
          selectedTime={selectedTime}
          title="تصميم متجاوب"
        />
      </div>
    </div>
  );
};

export default TimeSlotSelectorExample;
