import { Col, Row } from "antd";

export const LoadingSkeleton = () => (
    <Row gutter={[24, 24]} className='transition-all duration-500 ease-in-out'>
        {[1, 2, 3, 4, 5, 6].map((index) => (
            <Col
                key={index}
                lg={8}
                md={12}
                sm={24}
                xs={24}
                className='app__cars_slider transition-all duration-300 ease-in-out'
            >
                <div className="w-full  h-[420px] bg-mian relative app__cars_slider_container rounded-md shadow-md animate-pulse hover:scale-105 transition-all duration-300">
                    {/* Badge skeleton - top left */}
                    <div className="relative">
                        <div className="absolute top-2 left-2 w-16 h-6 bg-yellow-400 rounded-full opacity-60"></div>
                    </div>

                    {/* Car image skeleton - matches Card cover */}
                    <div className="w-full h-[300px] bg-gray-700 rounded-t-lg flex items-center justify-center">
                        <div className="w-32 h-20 bg-gray-600 rounded-lg"></div>
                    </div>

                    {/* Card content skeleton - matches slider_card */}
                    <div className="p-4 pb-6 space-y-3">
                        {/* Brand title skeleton */}
                        <div className="w-3/4 h-6 bg-gray-700 rounded"></div>


                        {/* Price and button skeleton */}
                        <div className="flex justify-between items-end mt-3">
                            <div className="flex items-center flex-col gap-2">
                                <div className="flex items-center gap-2">
                                    <div className="w-16 h-6 bg-gray-700 rounded"></div>
                                    <div className="w-12 h-5 bg-gray-600 rounded line-through"></div>
                                </div>
                                <div className="w-24 h-4 bg-gray-700 rounded"></div>
                            </div>
                            <div className="w-24 h-10 bg-gray-700 rounded"></div>
                        </div>
                    </div>
                </div>
            </Col>
        ))}
    </Row>
);

export default LoadingSkeleton;
