'use client';
import { Button, Modal } from "antd";
import { useLocale, useTranslations } from 'next-intl';
import { useRouter } from 'next/navigation';

/**
 * مكون Modal لعرض رسالة عدم توفر السيارة في الفرع المحدد
 * @param {boolean} open - حالة فتح/إغلاق الـ Modal
 * @param {Object} branchData - بيانات الفرع
 * @param {string} branchId - معرف الفرع
 * @param {function} onClose - دالة إغلاق الـ Modal
 * @param {boolean} loading - حالة التحميل (اختيارية)
 */
const CarUnavailableModal = ({
    open,
    branchData,
    branchId,
    onClose,
    loading = false
}) => {
    const t = useTranslations();
    const locale = useLocale();
    const router = useRouter();

    const handleViewOtherCars = () => {
        // الانتقال لصفحة السيارات مع معرف الفرع
        router.push(`/${locale}/cars?branchId=${branchId}&showBranchName=true`);
        onClose();
    };

    const handleClose = () => {
        onClose();
    };

    // الحصول على اسم الفرع بناءً على اللغة
    const branchName = locale === 'ar'
        ? (branchData?.branchArName || branchData?.branchName || `الفرع ${branchId}`)
        : (branchData?.branchName || branchData?.branchArName || `Branch ${branchId}`);

    return (
        <Modal
            open={open}
            onCancel={handleClose}
            footer={null}
            centered
            className="font-[Cairo] car-unavailable-modal"
            maskClosable={!loading}
            closable={false}
            width={400}
            styles={{
                body: { padding: '32px 24px' },
                content: { borderRadius: '12px', overflow: 'hidden' }
            }}
        >
            <div className="text-center">

                {/* Icon */}
                <div className="flex justify-center mb-6">

                    <svg width="80" height="80" viewBox="0 0 96 96" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M48.0002 87.9995C70.0916 87.9995 88.0002 70.0909 88.0002 47.9995C88.0002 25.9081 70.0916 7.99951 48.0002 7.99951C25.9089 7.99951 8.00024 25.9081 8.00024 47.9995C8.00024 70.0909 25.9089 87.9995 48.0002 87.9995Z" stroke="#CE931A" stroke-width="7.86885" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M48 31.9995V47.9995" stroke="#CE931A" stroke-width="7.86885" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M48 64.0005H48.0392" stroke="#CE931A" stroke-width="7.86885" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>

                </div>

                {/* Message */}
                <p className="text-gray-800 text-base mb-6 leading-relaxed">
                    {t('car_unavailable.message') || 'عذراً، هذه السيارة غير متوفرة في الفرع المحدد:'}
                </p>

                <p className="font-semibold text-gray-800 text-lg mb-6">
                    {branchName}
                </p>

                {/* Single Button */}
                <Button
                    type="primary"
                    onClick={handleViewOtherCars}
                    loading={loading}
                    className="bg-[#CE931A] shadow-none hover:bg-[#B8821A] border-[#CE931A] hover:border-[#B8821A] h-12 px-8 rounded-lg font-medium"
                >
                    {t('car_unavailable.view_other_cars') || 'عرض سيارات أخرى في نفس الفرع'}
                </Button>
            </div>
        </Modal>
    );
};

export default CarUnavailableModal;
