'use client';

import {
  calculateProgressWidth,
  getHandleState,
  getTierDisplayData
} from "@/utils/membershipUtils";
import Lottie from "lottie-react";
import { useLocale, useTranslations } from "next-intl";
import { useSelector } from "react-redux";

const TierList = ({ points }) => {
  const locale = useLocale();
  const { memberships } = useSelector((state) => state.shared);

  const t = useTranslations("points_sidebar");

  const isRTL = locale == "ar";
  const textDirection = isRTL ? "rtl" : "ltr";

  // Import Lottie animations
  const goldAnimation = require("/public/assets/gif/gold.json");
  const silverAnimation = require("/public/assets/gif/Silver.json");
  const platinumAnimation = require("/public/assets/gif/Plantinium.json");

  const animations = {
    silver: silverAnimation,
    gold: goldAnimation,
    platinum: platinumAnimation
  };

  // Get tier data from API
  const tierDisplayData = getTierDisplayData(memberships, t);
  // Fallback to default tiers if no API data
  const tiers = tierDisplayData.length > 0 && tierDisplayData;

  // Check if points is 0 for empty state
  const isEmptyState = points === 0;

  // Calculate progress width using API data
  const getProgressWidth = () => {
    if (isEmptyState) {
      return 0; // No progress when points is 0
    }

    return calculateProgressWidth(points, tierDisplayData);
  };

  // Get handle state using API data
  const getHandleStateFromAPI = (index) => {
    return getHandleState(index, points, tierDisplayData, animations);
  };

  return (
    <div className="w-full mt-4 px-2" dir={textDirection}>
      {/* Tier labels */}
      <div className="flex justify-between mb-4">
        {tiers.map((tier, index) => (
          <span key={index} className="text-sm font-medium text-gray-700 text-center flex-1">
            {locale == "ar" ? tier.arabicName : tier.name}
          </span>
        ))}
      </div>

      {/* Main slider track */}
      <div className="relative h-3 bg-gray-300 rounded-full mb-4">
        {/* Progress fill */}
        <div
          className="absolute top-0 h-full rounded-full transition-all duration-300"
          style={isRTL
            ? {
                width: `${getProgressWidth()}%`,
                right: 0,
                background: '#EAD3A2',
                boxShadow: '0px 4px 4px 0px #FFFFFF42 inset, 1px -4px 4px 0px #0000000F inset'
              }
            : {
                width: `${getProgressWidth()}%`,
                left: 0,
                background: '#EAD3A2',
                boxShadow: '0px 4px 4px 0px #FFFFFF42 inset, 1px -4px 4px 0px #0000000F inset'
              }
          }
        ></div>

        {/* Handles - Positioned in the middle with space after Platinum */}
        {[
          { index: 0, position: 73 },      // Bronze - 75% from left
          { index: 1, position: 48 },      // Silver - 50% from left  
          { index: 2, position: 22 },      // Gold - 25% from left
          // { index: 3, position: 0 }        // Platinum - 0% from left
        ].map(({ index, position }) => {
          const tier = tiers[index];
          if (!tier) return null;
          const handleState = getHandleStateFromAPI(index);

          return (
            <div key={index}>
              {/* Handle */}
              <div
                className="absolute top-1/2 transform  -translate-y-1/2 w-6 h-6 rounded-full border-2 border-white shadow-lg transition-all duration-300"
                style={locale == "en"
                  ? { right: `${position}%`, backgroundColor: handleState.color }
                  : { left: `${position}%`, backgroundColor: handleState.color }
                }
              >
                {handleState.animation && (
                  <div className="flex items-center justify-center w-full h-full">
                    <Lottie
                      animationData={handleState.animation}
                      loop={true}
                      autoplay={true}
                      style={{ width: '20px', height: '20px' }}
                    />
                  </div>
                )}
                {handleState.icon === "check" && (
                  <div className="flex items-center justify-center  w-full h-full">
                    <svg className="w-3 h-3 text-white" fill="currentColor" viewBox="0 0 20 20">
                      <path fillRule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clipRule="evenodd" />
                    </svg>
                  </div>
                )}
              </div>

              {/* Number under handle */}
              <div
                className="absolute top-full text-xs font-medium text-gray-700 mt-4"
                style={locale == "en"
                  ? { right: `${position}%`, transform: 'translateX(25%)' }
                  : { left: `${position}%`, transform: 'translateX(-25%)' }
                }
              >
                {index === 0 && tierDisplayData[0]?.endPoints?.toLocaleString()}
                {index === 1 && tierDisplayData[1]?.endPoints?.toLocaleString()}
                {index === 2 && tierDisplayData[2]?.endPoints?.toLocaleString()}
              </div>
            </div>
          );
        })}
      </div>

      {/* Values under tier labels - removed */}
    </div>
  );
};

export default TierList;