import Icon from '@/constants/icon';
import { Info } from 'lucide-react';
import { useSelector } from 'react-redux';

const PointsInfo = ({ t }) => {
    const { settings } = useSelector((state) => state.shared);
    return (
        <div className="w-full px-2 space-y-1 text-sm">
            <section className="pt-3 py-4">
                <div className="flex items-center gap-2 [&_svg]:w-5 [&_svg]:h-5 [&_svg]:text-main  [&_svg]:fill-current">
                    <Icon.PointIcon />
                    <p className="text-main text-[16px] font-bold">{t("earn_points_title")}</p>
                </div>
                <p className="text-custom mt-2">{t("earn_points_info", { points: settings?.POINTS_EARNED_PER_SAR })}</p>
            </section>
            <section className="pt-3 py-4">
                <div className="flex items-center gap-2 [&_svg]:w-5 [&_svg]:h-5 [&_svg]:text-main  [&_svg]:fill-current">
                    <Icon.TimerIcon />
                    <p className="text-[16px] text-main font-bold">{t("validity_title")}</p>
                </div>
                <p className="text-custom mt-2">{t("validity_info", { days: settings?.POINTS_EXPIRATION_DAYS })}</p>
            </section>
            <section className="space-y-3 pt-5">
                <div className="flex items-center gap-2 [&_svg]:w-5 [&_svg]:h-5 [&_svg]:text-main  [&_svg]:fill-current">
                    <Icon.StackedCoins />
                    <p className="text-main text-[16px] font-bold">{t("how_to_use_points_title")}</p>
                </div>
                {/* <p className="text-custom">{t("use_points_info")}</p> */}

                <div className="space-y-3 !mt-3">
                    <p className="bg-[#CE931A14] px-2 py-2 !text-[13px] flex items-center gap-2">
                        <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect y="0.722656" width="14" height="14" rx="7" fill="#D7A642" />
                            <circle cx="7" cy="7.72266" r="3.5" fill="#F9F2E3" />
                        </svg>
                        {t("option_1")}
                    </p>
                    <p className="bg-[#CE931A14] px-2 py-2 !text-[13px] flex items-center gap-2">
                        <svg width="11" height="11" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect y="0.722656" width="14" height="14" rx="7" fill="#D7A642" />
                            <circle cx="7" cy="7.72266" r="3.5" fill="#F9F2E3" />
                        </svg>
                        {t("option_2")}
                    </p>
                    <p className="bg-[#CE931A14] px-2 py-2 !text-[13px] flex items-center gap-2">
                        <svg width="11" height="11" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect y="0.722656" width="14" height="14" rx="7" fill="#D7A642" />
                            <circle cx="7" cy="7.72266" r="3.5" fill="#F9F2E3" />
                        </svg>
                        {t("option_4", { points: settings?.POINTS_SPENT_PER_SAR })}
                    </p>
                    <p className="bg-[#CE931A14] px-2 py-2 !text-[13px] flex items-center gap-2">
                        <svg width="11" height="11" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect y="0.722656" width="14" height="14" rx="7" fill="#D7A642" />
                            <circle cx="7" cy="7.72266" r="3.5" fill="#F9F2E3" />
                        </svg>
                        {t("option_3")}
                    </p>
                </div>
            </section>

            <section className="pt-5">
                <div className="flex items-center gap-2 [&_svg]:w-5 [&_svg]:h-5 [&_svg]:text-main  [&_svg]:fill-current">
                    <Icon.TermsIcon />
                    <p className="text-main text-[16px] font-bold">{t("terms_title")}</p>
                </div>
                <ul className="space-y-2 mt-3">
                    <div className="bg-[#CE931A14] px-2 py-3 flex items-start gap-2">
                        <Info strokeWidth={1.5} width={18} height={18} color="#000" className="mt-2" />
                        <p className="!text-[13px]">{t("term_1", { points: settings?.MAX_POINTS_PER_USE })}</p>
                    </div>
                    <div className="bg-[#CE931A14] px-2 py-3 flex items-start gap-2">
                        <Info strokeWidth={1.5} width={35} height={35} color="#000" />
                        <p className="!text-[13px] text-justify">{t("term_2")}</p>
                    </div>
                </ul>
            </section>


        </div>
    )
}

export default PointsInfo
