"use client";
import { Link, usePathname } from "@/navigation";
import { CarFront, Home, MapPin, Menu } from 'lucide-react';
import { useTranslations } from "next-intl";

const MobileNavLinks = ({ onMenuClick }) => {
  const t = useTranslations();
  const pathname = usePathname();

  return (
    <div className="flex justify-around items-center px-4 py-3">
      <Link 
        href="/" 
        className={`flex flex-col gap-2 items-center text-sm hover:text-secondary ${
          pathname === "/" ? "text-secondary" : "text-gray-700"
        }`}
      >
        <Home 
          className="w-5 h-5" 
          color={pathname === "/" ? "#CE931A" : "#606060"} 
          strokeWidth={1.5} 
        />
        <span>{t("nav_home")}</span>
      </Link>

      <Link 
        href="/cars" 
        className={`flex flex-col gap-2 items-center text-sm hover:text-secondary ${
          pathname.includes("/cars") || pathname.includes("/limo") ? "text-secondary" : "text-gray-700"
        }`}
      >
        <div className={pathname.includes("/cars") || pathname.includes("/limo") ? "text-secondary" : "text-gray-700"}>
  
          <CarFront strokeWidth={1} size={20} />
        </div>
        <span>{t("nav_fleet")}</span>
      </Link>

      <Link 
        href="/branches" 
        className={`flex flex-col gap-2 items-center text-sm hover:text-secondary ${
          pathname === "/branches" ? "text-secondary" : "text-gray-700"
        }`}
      >
        <MapPin 
          className="w-5 h-5" 
          color={pathname === "/branches" ? "#CE931A" : "#606060"} 
          strokeWidth={1.5} 
        />
        <span>{t("nav_branches")}</span>
      </Link>

      <div
        className="flex flex-col gap-2 items-center text-sm text-gray-700 cursor-pointer hover:text-main"
        onClick={onMenuClick}
      >
        <Menu className="w-5 h-5" color="#606060" strokeWidth={1.5} />
        <span>{t("more")}</span>
      </div>
    </div>
  );
};

export default MobileNavLinks;
