"use client";
import Icon from '@/constants/icon';
import img from "@/constants/img";
import { Link, useRouter } from "@/navigation";
import { isAuthenticated, handleLogout as logoutUser } from '@/utils/authUtils';
import { LoginOutlined } from '@ant-design/icons';
import Avater from '@components/svg/Avater';
import { PageContainer } from '@components/ui';
import { Drawer, message } from 'antd';
import { CarFrontIcon, CarTaxiFront, Newspaper, ShieldBan } from 'lucide-react';
import { useLocale, useTranslations } from "next-intl";
import Image from 'next/image';
import { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';

const MobileDrawerMenu = ({ visible, onClose, onPointsClick, onLanguageClick }) => {
  const t = useTranslations();
  const locale = useLocale();
  const router = useRouter();
  const [isLoggedIn, setIsLoggedIn] = useState(false);
  const { user } = useSelector((state) => state.profile);

  // Check if user is logged in
  useEffect(() => {
    setIsLoggedIn(isAuthenticated());
  }, [visible]);

  const handlePointsClick = () => {
    onPointsClick();
    onClose();
  };

  const handleItemClick = () => {
    onClose();
  };

  const handleLogout = () => {
    const success = logoutUser();

    if (success) {
      message.success(t("logout_success"));
      onClose();
      router.push("/");
    } else {
      message.error(t("logout_error") || "Logout failed");
    }
  };

  return (
    <Drawer
      title={
        <div className="flex justify-between items-center">
          <div></div>
          <div className="text-lg font-semibold text-gray-800">{t("more")}</div>
          <div>
            <Image src={img.logoDark} alt="الغزال" priority width={50} height={30} />
          </div>
        </div>
      }
      placement="bottom"
      closable={true}
      onClose={onClose}
      open={visible}
      height="100%"
      styles={{
        body: { padding: 0 },
      }}
      className="points-sidebar [&_.ant-drawer-body]:p-3  [&_.ant-drawer-body]:bg-[#fbf3e0] "

    >
      <PageContainer showPadding={true} showBorder={true} className="py-4 !pt-6  px-4 max-sm:!px-0" >
        {/* First Section */}
        <div className="flex flex-col gap-3 py-5  max-sm:!px-4">
          {isLoggedIn && user && (
            <div className="mb-7 flex flex-row  justify-center   items-سف gap-3">
              {user?.image ? (
                <Image src={user?.image} alt="user" width={80} height={80} className="rounded-[50%] object-cover h-[80px] w-[80px] max-sm:!w-[60px] max-sm:!h-[60px]" />
              ) : (
                <Avater />
              )}
              <div className="flex flex-col items-start  justify-center gap-1 w-full">
                <h3 className="text-lg font-semibold text-gray-800">
                  {user?.firstName && user?.lastName
                    ? `${user.firstName.charAt(0).toUpperCase() + user.firstName.slice(1)} ${user.lastName.charAt(0).toUpperCase() + user.lastName.slice(1)}`
                    : user?.firstName || user?.lastName || t("user")}
                </h3>
                <p className="text-sm text-[#D4AF37]">
                  {locale === 'ar'
                    ? (user?.membershipArName || user?.membershipName || t("membership.guest"))
                    : (user?.membershipName || user?.membershipArName || t("membership.guest"))}
                </p>
              </div>
            </div>
          )}
          {isLoggedIn && (
            < >
              <Link href="/profile" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
                <div className="w-[20px] h-[20px] text-![#606060] [&_svg]:w-full [&_svg]:h-full [&_svg]:fill-current">
                  <Icon.User />
                </div>
                <span>{t("profile.personalInfo")}</span>
              </Link>
              <hr className="border-gray-200 my-1" />

              <Link href="/current-reservations" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
                <div className="w-[20px] h-[20px] text-![#606060] [&_svg]:w-full [&_svg]:h-full ">
                  <CarFrontIcon strokeWidth={1} size={20} />
                </div>
                <span>{t("menu.current_car")}</span>
              </Link>
              <hr className="border-gray-200 my-1" />
              {/* profile/update-password  */}

              <Link href="/current-limousine-reservations" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
                <div className="w-[20px] h-[20px] text-![#606060] [&_svg]:w-full [&_svg]:h-full ">
                  <CarTaxiFront strokeWidth={1} size={20} />
                </div>
                <span>{t("menu.current_limo")}</span>
              </Link>
              <hr className="border-gray-200 my-1" />
              <Link href="/profile/update-password" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
                <div className="w-[20px] h-[20px] text-![#606060] [&_svg]:w-full [&_svg]:h-full ">
                  <ShieldBan strokeWidth={1} />
                </div>
                <span>{t("menu.change_password")}</span>
              </Link>
              <hr className="border-gray-200 my-1" />

              <div onClick={handlePointsClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main cursor-pointer">
                <div className="w-[20px] h-[20px] text-[#606060] [&_svg]:w-full [&_svg]:h-full [&_svg]:fill-current">
                  <Icon.OfferIcons />
                </div>
                <span>{t("points")}</span>
              </div>
              <hr className="border-gray-200 my-1" />

            </>
          )}

          <Link href="/cars" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
            <Icon.CarIcon />
            <span>{t("nav_fleet")}</span>
          </Link>
          <hr className="border-gray-200 my-1" />

          <Link href="/membership" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
            <Icon.MembershipIcon />
            <span>{t("nav_membership")}</span>
          </Link>
          <hr className="border-gray-200 my-1" />

          {/* <Link href="/offers" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
            <div className="w-[23px] h-[23px] text-[#606060] [&_svg]:w-full [&_svg]:h-full [&_svg]:fill-current">
              <Icon.OfferIcons />
            </div>
            <span>{t("offer")}</span>
          </Link>
          <hr className="border-gray-200 my-1" /> */}

          <Link href={`https://wa.me/+966550383555`} onClick={handleItemClick} target='_blank' className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
            <div className="w-[20px] h-[20px] text-[#606060] [&_svg]:w-full [&_svg]:h-full [&_svg]:fill-current">
              <Icon.ContactIcons />
            </div>
            <span>{t("talk_to_us")}</span>
          </Link>
          <hr className="border-gray-200 my-1" />

          <div onClick={onLanguageClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main cursor-pointer">
            <div className="w-[20px] h-[20px] text-![#606060] [&_svg]:w-full [&_svg]:h-full [&_svg]:fill-current">
              <Icon.LangIcons />
            </div>
            <span>{t("lang_title")}</span>
          </div>

          <hr className="border-gray-200 my-1" />
          <Link href="/about" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
            <div className="w-[20px] h-[20px] text-![#606060] [&_svg]:w-full [&_svg]:h-full [&_svg]:fill-current">
              <Icon.User />
            </div>
            <span>{t("nav_about")}</span>
          </Link>
          <hr className="border-gray-200 my-1" />

          <Link href="/contactus" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
            <div className="w-[20px] h-[20px] text-[#606060] [&_svg]:w-full [&_svg]:h-full [&_svg]:fill-current">
              <Icon.Phone />
            </div>
            <span>{t("nav_contact")}</span>
          </Link>
          <hr className="border-gray-200 my-1" />


          <Link href="/blogs" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
            <div className="w-[20px] h-[20px] text-![#606060] [&_svg]:w-full [&_svg]:h-full ">
              <Newspaper strokeWidth={1} size={20} />
            </div>
            <span>{t("nav_blog")}</span>
          </Link>
          <hr className="border-gray-200 my-1" />

          {isLoggedIn ? (
            <div onClick={handleLogout} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main cursor-pointer">
              <LoginOutlined className="text-lg" />
              <span>{t("nav_logout")}</span>
            </div>
          ) : (
            <Link href="/login" onClick={handleItemClick} className="flex items-center gap-3 text-sm text-gray-700 hover:text-main">
              <LoginOutlined className="text-lg" />
              <span>{t("nav_login")}</span>
            </Link>
          )}
        </div>
      </PageContainer>
    </Drawer>
  );
};

export default MobileDrawerMenu;
