'use client'
import useIsMobile from "@/hook/useIsMobile";
import { usePathname, useRouter } from "@/navigation";
import { Layout } from 'antd';
import { useLocale } from "next-intl";
import { useSearchParams } from "next/navigation";
import { useState } from 'react';
import MobileDrawerMenu from './MobileDrawerMenu';
import MobileLanguageDrawer from './MobileLanguageDrawer';
import MobileNavLinks from './MobileNavLinks';

const { Footer } = Layout;

const BottomNavigation = ({ onPointsClick }) => {
    const [visible, setVisible] = useState(false);
    const [langDrawerVisible, setLangDrawerVisible] = useState(false);

    const locale = useLocale();
    const router = useRouter();
    const pathname = usePathname();
    const searchParams = useSearchParams();
    
    // Check if mobile or tablet using custom hook (handles SSR automatically)
    const { isMobile, isTablet } = useIsMobile(1000);

    // Handlers
    const showDrawer = () => setVisible(true);
    const onClose = () => setVisible(false);
    const showLanguageDrawer = () => setLangDrawerVisible(true);

    const handleLanguageSelect = async (lang) => {
        if (lang !== locale) {
            // Check if current path is a blog page with slug (e.g., /blogs/45/slug)
            const blogMatch = pathname.match(/^\/blogs\/(\d+)\/([^\/]+)/);
            
            if (blogMatch) {
                const blogId = blogMatch[1];
                
                try {
                    // Fetch blog data to get the correct slug for the new locale
                    const res = await fetch(`https://viganium.me/api/blog/find/${blogId}`, {
                        headers: { 'Content-Type': 'application/json', 'Accept': 'application/json' }
                    });
                    
                    if (res.ok) {
                        const response = await res.json();
                        const blogData = response?.status && response?.data ? response.data : response;
                        
                        if (blogData) {
                            // Get the correct slug for the new locale
                            const newSlug = lang === 'ar' 
                                ? (blogData.slugAr || 'blog-post')
                                : (blogData.slug || 'blog-post');
                            
                            // Build new path with correct slug
                            const newPath = `/blogs/${blogId}/${newSlug}`;
                            const params = new URLSearchParams(searchParams.toString());
                            const queryString = params.toString();
                            const pathnameWithParams = queryString ? `${newPath}?${queryString}` : newPath;
                            
                            router.replace(pathnameWithParams, { locale: lang });
                            return;
                        }
                    }
                } catch (error) {
                    console.error('Error fetching blog data for language switch:', error);
                    // Fall through to default behavior
                }
            }
            
            // Default behavior for non-blog pages or if blog fetch fails
            const params = new URLSearchParams(searchParams.toString());
            const queryString = params.toString();
            const pathnameWithParams = queryString ? `${pathname}?${queryString}` : pathname;
            
            router.replace(pathnameWithParams, { locale: lang });
        }
    };

    // Don't render if not mobile or tablet
    if (!(isMobile || isTablet)) {
        return null;
    }
    return (
        <Layout className="[&_.ant-layout-footer]:px-0 [&_.ant-layout-footer]:py-0">
            <Footer className="fixed bottom-0 w-full bg-white shadow-xl z-50">
                <MobileNavLinks onMenuClick={showDrawer} />
            </Footer>

            {/* Main Menu Drawer */}
            <MobileDrawerMenu
                visible={visible}
                onClose={onClose}
                onPointsClick={onPointsClick}
                onLanguageClick={showLanguageDrawer}
            />

            {/* Language Selection Drawer */}
            <MobileLanguageDrawer
                visible={langDrawerVisible}
                onClose={() => setLangDrawerVisible(false)}
                onLanguageSelect={handleLanguageSelect}
            />
        </Layout>
    );
};

export default BottomNavigation;
