"use client";
import img from "@/constants/img";
import { Link } from "@/navigation";
import { useLocale, useTranslations } from "next-intl";
import Image from "next/image";

const GuestActions = ({ onLanguageChange }) => {
  const t = useTranslations();
  const locale = useLocale();

  return (
    <>
      <div className="language-toggle cursor-pointer" onClick={() => onLanguageChange(locale === 'en' ? 'ar' : 'en')}>
        <span>{t('lang')}</span>
        <Image
          width={20}
          height={14}
          src={locale === 'en' ? img.LangAr : img.LangEn}
          alt="flag"
          className="w-auto h-auto"
        />
      </div>
      <Link href="/login" className="login-link">
        {t('nav_login')}
      </Link>
    </>
  );
};

export default GuestActions;
