'use client';

import { Button, Col, Input, Row, message } from 'antd';
import { useLocale, useTranslations } from 'next-intl';
import { useState } from 'react';
import './subscribed.css';

const Subscribed = () => {
  const locale = useLocale();
  const t = useTranslations('subscribed');
  const tValidation = useTranslations('validation');
  const [email, setEmail] = useState('');
  const [loading, setLoading] = useState(false);
  const [messageApi, contextHolder] = message.useMessage();

  const handleSubmit = async (e) => {
    e.preventDefault();

    // Validate email
    if (!email || !email.trim()) {
      messageApi.error(t('error'));
      return;
    }

    // Basic email validation
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email)) {
      messageApi.error(t('error'));
      return;
    }

    try {
      setLoading(true);

      const response = await fetch('/api/email-lists', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ email: email.trim() }),
      });

      const result = await response.json();
      console.log(result);
      if (response.ok && result.emailId) {
        messageApi.success(t('success_message'));
        setEmail(''); // Clear the input after successful submission
      } else {
        // Handle specific error messages
        if (result.message && result.message.includes('exist')) {
          messageApi.warning(t('already_exists'));
        } else {
          messageApi.error(tValidation(result.message));
        }
      }
    } catch (error) {
      // Check if error message contains "exist" or "already"
      if (error.message && (error.message.includes('exist') || error.message.includes('already'))) {
        messageApi.warning(t('already_exists'));
      } else {
        messageApi.error(t('error'));
      }
    } finally {
      setLoading(false);
    }
  };

  return (
    <div className="app__service2-home min-h-[95px] ">
      {contextHolder}
      <Row className="bg_Subscribed w-full mt-4 flex justify-center items-center" gutter={[32, 32]}>
        <Col xs={24} sm={24} md={12}>
          <div className="flex flex-col justify-center items-center gap-3">
            <h3>{t('title')}</h3>
            {/* <p>{t('description')}</p> */}
          </div>
        </Col>

        <Col xs={24} sm={24} md={12}>
          <form className="w-full" onSubmit={handleSubmit}>
            <div className="groups_btn-input m-auto">
              <Input
                id="email"
                name="email"
                type="email"
                placeholder={t('email_placeholder')}
                dir={locale === "en" ? "ltr" : "rtl"}
                className="w-50"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
                disabled={loading}
              />
              <Button
                htmlType="submit"
                loading={loading}
                disabled={loading}
                className="!bg-main !text-white px-10  w-full h-[50px] max-sm:!px-0 block max-sm:!h-[40px] max-sm:!text-xs max-sm:!font-medium"
              >
                {t('submit')}
              </Button>
            </div>
          </form>
        </Col>
      </Row>
    </div>
  );
};

export default Subscribed;
