'use client'
import { CaretLeftOutlined, CaretRightOutlined } from '@ant-design/icons';
import { Row, Col, Button } from 'antd';
import { Link } from "@/navigation";

export default function ActionButtons({ t, back, next }) {
  return (
    <Row gutter={[16, 16]} className=" mt-[40px] mb-8">
      <Col xs={24} md={8}>
        <Link href={back}>
          <Button
            size="large"
            type="default"
            block
            icon={<CaretLeftOutlined />}
            className="rounded-[15px] h-[54px] [&_span]:text-[14px] [&_span]:font-medium [&_svg]:rotate-[180deg] "
            iconPosition="start"
          >
            {t("back_to_cars")}
          </Button>
        </Link>
      </Col>
      <Col xs={24} md={16}>
        <Link href={next}>
          <Button
            type="primary"
            size="large"
            block
            icon={<CaretRightOutlined />}
            className="rounded-[15px] h-[54px] [&_span]:text-[14px] [&_span]:font-medium [&_svg]:rotate-[180deg] "
            iconPosition="end"
          >
            {t("complete_payment")}
          </Button>
        </Link>
      </Col>
    </Row>
  );
}