'use client';

import { Link } from '@/navigation';
import { Button, Card } from 'antd';
import { useLocale, useTranslations } from 'next-intl';
import Image from 'next/image';
import './card.css';
import noImage from '/public/assets/Images/test/Car.png';

const CardsBooking = ({ item, limo }) => {
    const locale = useLocale();
    const t = useTranslations();
    const carImage = item.defaultImage || item.image || noImage; 

    return (
        <Card
            hoverable
            className=" w-full bg-mian relative app__cars_slider_container overflow-hidden"
            cover={
                <div className="w-full h-[200px] overflow-hidden">
                    <Image
                        src={carImage}
                        alt={`${locale === "en" ? item?.brandName : item?.brandArabicName} ${locale === "en" ? item?.modelEnglishName : item?.modelArabicName} ${item?.year}`}
                        width={400}
                        height={200}
                        className="w-full h-full object-contain"
                    />
                </div>
            }
        >
            <div className="slider_card" dir={locale === "en" ? 'ltr' : 'rtl'}>
                <ul>
                    <li className='sub_brand_title'>
                        <strong>{locale === "en" ? item?.brandName : item?.brandArabicName}</strong>
                    </li>
                    <li className='mt-3'>
                        <span>( {locale === "en" ? item?.modelEnglishName : item?.modelArabicName} )</span>
                    </li>
                    <li className='mt-3'>
                        <span className='bold'>{item?.year}</span>
                    </li>

                    {(item?.typeArabicName && item?.typeEnglishName) && (
                        <>
                            <div className="hr"><hr /></div>
                            <li>
                                <span>{locale === "ar" ? item?.typeArabicName : item?.typeEnglishName}</span>
                            </li>
                        </>
                    )}
                    {
                        limo ?
                            <Link className="w-full mt-4 " href={`/limousine-details/${item?.id}?car-name=${item?.brandArabicName}_${item?.modelArabicName}&limo=true`}>
                                <Button className="w-full bg-[#60606080] text-secondary !rounded-md" type="primary">  {t('details')} </Button>
                            </Link> :
                            <Link className="w-full mt-4 " href={`/booking-details/${item?.reservationId}?car-name=${item?.brandArabicName}_${item?.modelArabicName}&limo=false`}>
                                <Button className="w-full bg-[#60606080] text-secondary !rounded-md" type="primary">  {t('details')} </Button>
                            </Link>
                    }



                </ul>
            </div>

        </Card>
    )
}

export default CardsBooking;
