/**
 * Component لإدارة مسح sessionStorage عند refresh الصفحة
 * Component to manage sessionStorage clearing on page refresh
 */
'use client';

import { useClearOnRefresh } from '@/hook/useClearOnRefresh';

/**
 * Component يقوم بمسح sessionStorage تلقائياً عند refresh الصفحة
 * لا يعرض أي UI - فقط يدير sessionStorage
 */
const SessionStorageManager = () => {
  // تفعيل المسح التلقائي لـ sessionStorage عند refresh
  // يمكنك إضافة مفاتيح معينة في excludeKeys إذا أردت استثناءها من المسح
  useClearOnRefresh(true, [
    // مثال: إذا أردت استثناء بعض المفاتيح من المسح:
    // 'some_key_to_keep',
  ]);

  // لا يعرض أي UI
  return null;
};

export default SessionStorageManager;

