'use client'
import { openWhatsApp } from '@/utils/whatsappUtils';
import { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';
import WhatsApp from './svg/WhatsApp';

const FloatingWhatsApp = () => {
  const [isMounted, setIsMounted] = useState(false);
  const { contact } = useSelector((state) => state.shared);
  
  useEffect(() => {
    setIsMounted(true);
  }, []);
  
  const whatsappNumber = contact?.whatsapp;

  const handleWhatsAppClick = () => {
    if (whatsappNumber) {
      console.log('WhatsApp number before cleaning:', whatsappNumber);
      openWhatsApp(whatsappNumber);
    }
  };

  // Don't render until client-side hydration is complete
  if (!isMounted) {
    return null;
  }

  return (
    <div 
      className="fixed md:bottom-6 bottom-20 left-6 z-50 cursor-pointer group"
      onClick={handleWhatsAppClick}
      title="تواصل معنا عبر واتساب"
    >
      <div className="relative">
        {/* WhatsApp Icon */}
        <div className="w-14 h-14 bg-green-500 hover:bg-green-600 rounded-full flex items-center justify-center shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-110 group-hover:animate-pulse">
          <WhatsApp className="text-white" size={28} />
        </div> 
        
        {/* Pulse animation ring */}
        <div className="absolute inset-0 rounded-full bg-green-500 opacity-75 animate-ping"></div>
      </div>
    </div>
  );
};

export default FloatingWhatsApp;
