'use client';

import { Button } from 'antd';
import { useTranslations } from 'next-intl';
import { useEffect, useState } from 'react';
import LimCarsRentHourDay from './LimCarsRentHourDay';
import LimReceptionPricing from './LimReceptionPricing';

const LimousineForm = ({ locale }) => {
  const t = useTranslations();
  
  //TODO Types of reservation
  const rentalTypes = [
    { value: 'pickup', label: t('limousine.rental_types.pickup') },
    { value: 'hourly', label: t('limousine.rental_types.hourly') },
    { value: 'daily', label: t('limousine.rental_types.daily') },
  ];

  // استرجاع نوع الإيجار المحفوظ من sessionStorage
  const [rentalType, setRentalType] = useState(() => {
    if (typeof window !== 'undefined') {
      const saved = sessionStorage.getItem('limousine_rental_type');
      return saved || 'pickup';
    }
    return 'pickup';
  });

  // حفظ نوع الإيجار عند التغيير
  useEffect(() => {
    if (typeof window !== 'undefined') {
      sessionStorage.setItem('limousine_rental_type', rentalType);
    }
  }, [rentalType]);

  return (
    <div className="space-y-4">

      {/* [3] Reservation Type Buttons */}
      <div className="flex justify-start gap-2">
        {rentalTypes.map((type) => (
          <Button
            key={type.value}
            type="default"
            className={`border rounded-md px-6 py-1 max-sm:!px-4 max-sm:!py-1 max-sm:!text-xs ${rentalType === type.value ? '!bg-[#162A2B] !text-white' : ''}`}
            onClick={() => setRentalType(type.value)}
          >
            {type.label}
          </Button>
        ))}
      </div>

      {/* [4] Display the appropriate form based on type.value */}
      {rentalType === 'pickup' && (
        <LimReceptionPricing locale={locale} />
      )}

      {rentalType === 'hourly' && (
        <LimCarsRentHourDay locale={locale} rentalType="hourly" />
      )}

      {rentalType === 'daily' && (
        <LimCarsRentHourDay locale={locale} rentalType="daily" />
      )}
    </div>
  );
};

export default LimousineForm;
