// components/AdvancedRentalPanel/Tabs/TabsHeader.jsx
'use client';

import { Button } from 'antd';
import { useLocale, useTranslations } from 'next-intl';

const TabsHeader = ({ activeTab, setActiveTab }) => {
  const t = useTranslations();
  const locale = useLocale();
 
  const tabs = [
    { key: 'rental', label: t('rental') },
    { key: 'companies', label: t('companies') },
    { key: 'limousine', label: t('limousine.title') },
  ];

  return (
    <div className="flex sticky tabs_header  -mt-10   overflow-hidden ">
      {tabs.map((tab, index) => (
        <Button
          key={tab.key}
          onClick={() => setActiveTab(tab.key)}
          className={`px-2 md:px-10 py-2 text-sm md:text-lg font-semibold border transition-all duration-300 h-[45px] md:h-[55px]  
             ${ index === 0 
                ? (locale === 'ar' ? '!rounded-tr-[8px]' : '!rounded-tl-[8px]')
                : index === tabs.length - 1 
                ? (locale === 'ar' ? '!rounded-tl-[8px]' : '!rounded-tr-[8px]')
                : '!rounded-t-0' 
             }
            ${activeTab === tab.key
              ? `bg-white text-[#162A2B] `
              : 'lg:!bg-main1 !bg-main1 !text-white !hover:bg-main1 !hover:text-main px-2 md:px-4 py-2 rounded-md '
            }
            max-sm:!px-1 max-sm:!py-1 max-sm:!text-xs max-sm:!h-8 max-sm:!font-medium`}
          size="large"
        >
          <span className="truncate">{tab.label}</span>
        </Button>
      ))}
    </div>
  );
};

export default TabsHeader;
