'use client';

import { useRouter } from '@/navigation';
import { selectDuration } from '@/store/features/rental/rentalSelectors';
import { setDuration } from '@/store/features/rental/rentalSlice';
import { CalendarOutlined } from '@ant-design/icons';
import { Radio } from 'antd';
import { useTranslations } from 'next-intl';
import { useSearchParams } from 'next/navigation';
import { useDispatch, useSelector } from 'react-redux';

const DurationSelector = () => {
    const t = useTranslations();
    const dispatch = useDispatch();
    const duration = useSelector(selectDuration);
    const searchParams = useSearchParams();
    const router = useRouter();

    const durations = [
        { key: 'daily', label: t('daily') },
        { key: 'weekly', label: t('weekly') },
        { key: 'monthly', label: t('monthly') },
    ];


    const addParam = (newDuration) => {
        const params = new URLSearchParams(searchParams.toString());
        params.set("duration", newDuration); // add / update param
        router.push(`?${params.toString()}`, { scroll: false }); // push new url with params
    };
    return (
        <Radio.Group
            value={duration}
            onChange={(e) => {
                const newValue = e.target.value;
                dispatch(setDuration(newValue))
                addParam(newValue)
            }}
            className="flex gap-3 max-sm:gap-1"
        >
            {durations.map(({ key, label }) => (
                <Radio.Button
                    key={key}
                    value={key}
                    className={` !px-2 h-[27px] !rounded-sm !text-xs flex items-center gap-2  
                        ${duration === key
                            ? '!bg-[#162A2B] !text-white !border-[#162A2B]'
                            : '!bg-white !text-[#162A2B] !border-[#E0A939]'
                        }
                        max-sm:!px-3 max-sm:!h-6 max-sm:!text-[10px] max-sm:!font-medium max-sm:gap-1
`}
                    style={{ transition: 'all 0.3s ease-in-out' }}
                >
                    <div className="flex gap-2 max-sm:gap-1">
                        <CalendarOutlined className="text-[12px] max-sm:!text-[8px]" />
                        {label}
                    </div>
                </Radio.Button>
            ))}
        </Radio.Group>
    );
};

export default DurationSelector;
