'use client';

const FiltersSkeleton = () => {
  return (
    <div className="app_filter_cars !mt-[-150px] max-md:!mt-[-100px] mx-auto lg:p-4 md:p-0 max-md:px-4" style={{ minHeight: '280px' }}>
      {/* Tabs Header Skeleton */}
      <div className="flex sticky tabs_header -mt-10 overflow-hidden">
        {[1, 2, 3].map((index) => (
          <div
            key={index}
            className={`px-2 md:px-10 py-2 h-[45px] md:h-[55px] bg-gray-300 max-sm:!h-8 animate-pulse`}
            style={{ width: '160px' }}
          >
            <div className="h-full w-full bg-gray-400 rounded"></div>
          </div>
        ))}
      </div>

      {/* Main Content Skeleton */}
      <div className="main_content bg-white sticky shadow-md rounded-b-xl px-4 md:px-6 pt-6 md:pt-8 pb-6 md:pb-[28px] space-y-4">
        {/* Row 1: Toggle Buttons Skeleton */}
        <div className="flex gap-2 md:gap-4">
          <div className="flex-1 h-[45px] bg-gray-200 rounded-md animate-pulse"></div>
          <div className="flex-1 h-[45px] bg-gray-200 rounded-md animate-pulse"></div>
        </div>

        {/* Row 2: Duration Selector Skeleton */}
        <div className="flex gap-2 md:gap-4">
          <div className="flex-1 h-[45px] bg-gray-200 rounded-md animate-pulse"></div>
          <div className="flex-1 h-[45px] bg-gray-200 rounded-md animate-pulse"></div>
          <div className="flex-1 h-[45px] bg-gray-200 rounded-md animate-pulse"></div>
        </div>
        
        {/* Additional Form Fields Skeleton */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div className="h-[45px] bg-gray-200 rounded-md animate-pulse"></div>
          <div className="h-[45px] bg-gray-200 rounded-md animate-pulse"></div>
        </div>
        
        {/* Button Skeleton */}
        <div className="flex justify-center md:justify-end pt-4">
          <div className="w-full md:w-48 h-[50px] bg-gray-300 rounded-md animate-pulse"></div>
        </div>
      </div>
    </div>
  );
};

export default FiltersSkeleton;
