import { getRequestConfig } from 'next-intl/server';
import { notFound } from 'next/navigation';

export default getRequestConfig(async ({ requestLocale }) => {
  const locales = ['ar', 'en'];
  
  // This typically corresponds to the `[locale]` segment
  const locale = await requestLocale;

  // Ensure that a valid locale is used
  if (!locale || !locales.includes(locale)) {
    notFound();
  }

  return {
    locale,
    messages: {
      // Load modular translation files
      ...(await import(`../messages/${locale}/common.json`)).default,
      ...(await import(`../messages/${locale}/about.json`)).default,
      ...(await import(`../messages/${locale}/navigation.json`)).default,
      ...(await import(`../messages/${locale}/auth.json`)).default,
      ...(await import(`../messages/${locale}/cars.json`)).default,
      ...(await import(`../messages/${locale}/booking.json`)).default,
      ...(await import(`../messages/${locale}/profile.json`)).default,
      ...(await import(`../messages/${locale}/validation.json`)).default,
      ...(await import(`../messages/${locale}/pages.json`)).default,
      ...(await import(`../messages/${locale}/legal.json`)).default,
      ...(await import(`../messages/${locale}/limo.json`)).default,
      ...(await import(`../messages/${locale}/payment-result.json`)).default,
    },
  };
});
